function doPost(e) {
  try {
    var sheet = SpreadsheetApp.openById(
      "11iLzmCH_72gT8wyWnZygJ18KF0V1Jil7aDKVB2cLJ00"
    ).getActiveSheet();
    var data = JSON.parse(e.postData.contents);

    // Save the uploaded file (if provided)
    var fileUrl = "";
    if (data.pitchDeck) {
      try {
        var folder = DriveApp.getFolderById("YOUR_DRIVE_FOLDER_ID"); // Folder for pitch decks
        var blob = Utilities.newBlob(
          Utilities.base64Decode(data.pitchDeck.data),
          "application/pdf",
          data.pitchDeck.name
        );
        var file = folder.createFile(blob);
        fileUrl = file.getUrl();
      } catch (fileError) {
        console.error("File upload error:", fileError);
        // Continue with form submission even if file upload fails
      }
    }

    // Insert data into the sheet
    sheet.appendRow([
      new Date(),
      data.startupName || "",
      data.founderName || "",
      data.email || "",
      data.phone || "",
      data.website || "",
      data.stage || "",
      data.aiCategory || "",
      data.description || "",
      data.traction || "",
      data.funding || "",
      data.teamSize || "",
      fileUrl,
    ]);

    // Return success response
    return ContentService.createTextOutput(
      JSON.stringify({ status: "success", message: "Application submitted!" })
    ).setMimeType(ContentService.MimeType.JSON);
  } catch (error) {
    console.error("Error in doPost:", error);

    // Return error response
    return ContentService.createTextOutput(
      JSON.stringify({
        status: "error",
        message: "Submission failed: " + error.toString(),
      })
    ).setMimeType(ContentService.MimeType.JSON);
  }
}
